<?php

return [
    'name' => 'MenuBuilder',
    'MENU' => [
        'menu_type' => 'vertical',
        'menu_item_type' => 'link',
        'title' => '',
        'short_title' => '-',
        'is_route' => true,
        'route' => null,
        'url' => null,
        'active' => null,
        'order' => 0,
        'menu_level' => 0,
        'start_icon' => null,
        'end_icon' => null,
        'parent_id' => null,
        'link_class' => '',
        'item_class' => '',
        'permission' => [],
        'role' => [],
        'is_tooltip' => false,
        'is_disabled' => false,
    ],
    'ARRAY_MENU' => [
        [
            'title' => 'sidebar.main',
            'menu_item_type' => 'static',
            'permission' => ['view_dashboard', 'view_booking'],
            'order' => 0,
        ],
        [
            'start_icon' => 'fa-solid fa-gauge',
            'title' => 'sidebar.dashboard',
            'route' => 'backend.home',
            'permission' => ['view_dashboard'],
            'active' => ['app', 'app/dashboard'],
            'order' => 1,
        ],
        [
            'start_icon' => 'fa-solid fa-calendar-days',
            'title' => 'sidebar.calendar_bookings',
            'route' => 'backend.bookings.index',
            'active' => ['app/bookings'],
            'permission' => ['view_booking'],
            'order' => 2,
        ],
        [
            'title' => 'sidebar.company',
            'menu_item_type' => 'static',
            'permission' => ['booking_booking_tableview', 'view_branch', 'view_service'],
            'order' => 3,
        ],
        [
            'start_icon' => 'fa-solid fa-code-branch',
            'title' => 'sidebar.branches',
            'route' => 'backend.branch.index',
            'active' => ['app/branch'],
            'permission' => ['view_branch'],
            'order' => 4,
        ],
        [
            'start_icon' => 'fa-solid fa-calendar-days',
            'title' => 'sidebar.bookings',
            'route' => 'backend.bookings.datatable_view',
            'active' => ['app/bookings-table-view'],
            'permission' => ['booking_booking_tableview'],
            'order' => 5,
        ],
        [
            'start_icon' => 'fa-brands fa-servicestack',
            'title' => 'sidebar.services',
            'nickname' => 'service',
            'menu_item_type' => 'parent',
            'permission' => ['view_service'],
            'order' => 6,
            'children' => [
                [
                    'title' => 'sidebar.list',
                    'route' => 'backend.services.index',
                    'active' => ['app/services'],
                    'permission' => ['view_service'],
                    'order' => 0,
                    'menu_level' => 1,
                ],
                [
                    'title' => 'sidebar.categories',
                    'route' => 'backend.categories.index',
                    'active' => ['app/categories'],
                    'permission' => ['view_categories'],
                    'order' => 1,
                    'menu_level' => 1,
                ],
                [
                    'title' => 'sidebar.sub_categories',
                    'route' => 'backend.categories.index_nested',
                    'active' => ['app/sub-categories'],
                    'permission' => ['view_subcategories'],
                    'order' => 2,
                    'menu_level' => 1,
                ],
            ],
        ],
        [
            'title' => 'sidebar.users',
            'menu_item_type' => 'static',
            'permission' => ['view_customer', 'view_staff', 'view_customer_reviews'],
            'order' => 9,
        ],
        [
            'start_icon' => 'fa-solid fa-address-card',
            'title' => 'sidebar.staffs',
            'route' => 'backend.employees.index',
            'active' => ['app/employees'],
            'permission' => ['view_staff'],
            'order' => 10,
        ],
        [
            'start_icon' => 'fa-solid fa-users',
            'title' => 'sidebar.customers',
            'route' => 'backend.customers.index',
            'active' => ['app/customers'],
            'permission' => ['view_customer'],
            'order' => 11,
        ],
        [
            'start_icon' => 'fa-solid fa-star',
            'title' => 'sidebar.reviews',
            'route' => 'backend.employees.review',
            'active' => ['app/employees-review'],
            'permission' => ['view_customer_reviews', 'view_earning'],
            'order' => 12,
        ],
        [
            'title' => 'sidebar.finance',
            'menu_item_type' => 'static',
            'permission' => ['view_tax', 'view_earning'],
            'order' => 13,
        ],
        [
            'start_icon' => 'fa-solid fa-money-bill-trend-up',
            'title' => 'sidebar.tax',
            'route' => 'backend.tax.index',
            'active' => ['app/tax'],
            'permission' => ['view_tax'],
            'order' => 14,
        ],
        [
            'start_icon' => 'fa-solid fa-money-bill-1-wave',
            'title' => 'sidebar.staff_earnings',
            'route' => 'backend.earnings.index',
            'active' => ['app/earnings'],
            'permission' => ['view_earning'],
            'order' => 15,
        ],
        [
            'start_icon' => 'fa-solid fa-ticket',
            'title' => 'sidebar.promotion',
            'route' => 'backend.promotions.index',
            'active' => ['app/promotions'],
            'permission' => ['view_role_permissions'],
            'order' => 16,
            'menu_level' => 1,
        ],
        [
            'title' => 'sidebar.reports',
            'menu_item_type' => 'static',
            'permission' => ['daily_booking_report', 'overall_booking_report', 'payout_report', 'employee_report'],
            'order' => 17,
        ],
        [
            'start_icon' => 'fa-solid fa-file-invoice-dollar',
            'title' => 'sidebar.daily_bookings',
            'route' => 'backend.reports.daily-booking-report',
            'active' => ['app/daily-booking-report'],
            'permission' => ['daily_booking_report'],
            'order' => 18,
        ],
        [
            'start_icon' => 'fa-solid fa-chart-line',
            'title' => 'sidebar.overall_bookings',
            'route' => 'backend.reports.overall-booking-report',
            'active' => ['app/overall-booking-report'],
            'permission' => ['overall_booking_report'],
            'order' => 19,
        ],
        [
            'start_icon' => 'fa-solid fa-chart-bar',
            'title' => 'sidebar.staffs_payouts',
            'route' => 'backend.reports.payout-report',
            'active' => ['app/payout-report'],
            'permission' => ['payout_report'],
            'order' => 20,
        ],
        [
            'start_icon' => 'fa-solid fa-clipboard-user',
            'title' => 'sidebar.staffs_services',
            'route' => 'backend.reports.staff-report',
            'active' => ['app/staff-report'],
            'permission' => ['employee_report'],
            'order' => 21,
        ],
        [
            'title' => 'sidebar.system',
            'menu_item_type' => 'static',
            'permission' => ['setting_general', 'setting_misc', 'setting_quick_booking', 'setting_custom_code', 'setting_customization', 'setting_mail', 'setting_notification', 'setting_intigrations', 'setting_custom_fields', 'setting_currency', 'setting_commission', 'setting_holiday', 'setting_bussiness_hours', 'setting_payment_method', 'setting_language', 'setting_menu_builder', 'view_page', 'view_app_banner', 'view_role_permissions'],
            'order' => 22,
        ],
        [
            'start_icon' => 'fa-solid fa-gear',
            'title' => 'sidebar.settings',
            'route' => 'backend.settings',
            'active' => 'app/settings',
            'permission' => ['system_settings'],
            'order' => 23,
        ],
        [
            'start_icon' => 'fa-solid fa-file',
            'title' => 'sidebar.pages',
            'route' => 'backend.pages.index',
            'active' => ['app/pages'],
            'permission' => ['view_page'],
            'order' => 24,
        ],
        [
            'start_icon' => 'fa-solid fa-bell',
            'title' => 'sidebar.notifications',
            'nickname' => 'notifications',
            'order' => 25,
            'permission' => ['view_notification_list', 'view_notification_template'],
            'menu_item_type' => 'parent',
            'children' => [
                [
                    'title' => 'sidebar.list',
                    'route' => 'backend.notifications.index',
                    'active' => 'app/notifications',
                    'permission' => ['view_notification_list'],
                    'order' => 0,
                    'menu_level' => 1,
                ],
                [
                    'title' => 'sidebar.templates',
                    'route' => 'backend.notification-templates.index',
                    'active' => 'app/notification-templates*',
                    'permission' => ['view_notification_template'],
                    'order' => 1,
                    'menu_level' => 1,
                ],
            ],
        ],
        [
            'start_icon' => 'fa fa-sliders',
            'title' => 'sidebar.app_banner',
            'route' => 'backend.app-banners.index',
            'active' => 'app/app-banners',
            'permission' => ['view_app_banner'],
            'order' => 26,
        ],
        [
            'start_icon' => 'fa-solid fa-user-shield',
            'title' => 'sidebar.access_control',
            'route' => 'backend.permission-role.list',
            'active' => ['app/permission-role'],
            'permission' => ['view_role_permissions'],
            'order' => 27,
        ],

        // [
        //     'start_icon' => 'fa-solid fa-cube',
        //     'title' => 'Modules',
        //     'route' => 'backend.module.index',
        //     'active' => ['app/module'],
        //     'order' => 25,
        //     'status' => 0,
        // ],
        // [
        //     'start_icon' => 'fa-solid fa-id-badge',
        //     'title' => 'Constants',
        //     'route' => 'backend.constants.index',
        //     'active' => ['app/constants*'],
        //     'order' => 26,
        //     'status' => 0,
        // ],
        // [
        //     'title' => 'Subscriptions',
        //     'order' => 27,
        //     'status' => 0,
        //     'start_icon' => 'fa-solid fa-ticket',
        //     'nickname' => 'subscriptions',
        //     'menu_item_type' => 'parent',
        //     'children' => [
        //         [
        //             'title' => 'My Account',
        //             'route' => 'backend.subscription.account.index',
        //             'active' => ['app/subscriptions/account'],
        //             'order' => 0,
        //         ],
        //         [
        //             'title' => 'Subscription List',
        //             'route' => 'backend.subscriptions.index',
        //             'active' => 'app/subscriptions',
        //             'order' => 1,
        //         ],
        //         [
        //             'title' => 'Plan List',
        //             'route' => 'backend.subscription.plans.index',
        //             'active' => 'app/subscriptions/plans',
        //             'order' => 2,
        //         ],
        //         [
        //             'title' => 'Plan Limitation',
        //             'route' => 'backend.subscription.planlimitation.index',
        //             'active' => 'app/subscriptions/planlimitation',
        //             'order' => 3,
        //         ],
        //     ],
        // ],
        // [
        //     'start_icon' => 'fa-solid fa-server',
        //     'title' => 'Backups',
        //     'route' => 'backend.backups.index',
        //     'active' => 'app/backups',
        //     'order' => 28,
        //     'status' => 0,
        // ],
    ],
    'H_ARRAY_MENU' => [
        [
            'menu_type' => 'horizontal',
            'title' => 'sidebar.main',
            'menu_item_type' => 'parent',
            'permission' => ['view_dashboard', 'view_booking'],
            'order' => 0,
            'children' => [
                [
                    'menu_type' => 'horizontal',
                    'start_icon' => 'fa-solid fa-gauge',
                    'title' => 'sidebar.dashboard',
                    'route' => 'backend.home',
                    'active' => ['app', 'app/dashboard'],
                    'permission' => ['view_dashboard'],
                    'order' => 0,
                    'menu_level' => 1,
                ],
                [
                    'menu_type' => 'horizontal',
                    'start_icon' => 'fa-solid fa-calendar-days',
                    'title' => 'sidebar.calendar_bookings',
                    'route' => 'backend.bookings.index',
                    'active' => ['app/bookings'],
                    'permission' => ['view_booking'],
                    'order' => 1,
                    'menu_level' => 1,
                ],
            ],
        ],
        [
            'menu_type' => 'horizontal',
            'title' => 'sidebar.company',
            'menu_item_type' => 'parent',
            'order' => 1,
            'permission' => ['booking_booking_tableview', 'view_branch', 'view_service'],
            'children' => [
                [
                    'menu_type' => 'horizontal',
                    'start_icon' => 'fa-solid fa-code-branch',
                    'title' => 'sidebar.branches',
                    'route' => 'backend.branch.index',
                    'active' => ['app/branch'],
                    'permission' => ['view_branch'],
                    'order' => 0,
                    'menu_level' => 1,
                ],
                [
                    'menu_type' => 'horizontal',
                    'start_icon' => 'fa-solid fa-calendar-days',
                    'title' => 'sidebar.bookings',
                    'route' => 'backend.bookings.datatable_view',
                    'active' => ['app/bookings-table-view'],
                    'permission' => ['booking_booking_tableview'],
                    'order' => 1,
                    'menu_level' => 1,
                ],
                [
                    'menu_type' => 'horizontal',
                    'start_icon' => 'fa-brands fa-servicestack',
                    'title' => 'sidebar.services',
                    'nickname' => 'service',
                    'menu_item_type' => 'parent',
                    'order' => 2,
                    'menu_level' => 1,
                    'permission' => ['view_service'],
                    'children' => [
                        [
                            'menu_type' => 'horizontal',
                            'title' => 'sidebar.list',
                            'route' => 'backend.services.index',
                            'active' => ['app/services'],
                            'permission' => ['view_service'],
                            'order' => 0,
                            'menu_level' => 2,
                        ],
                        [
                            'menu_type' => 'horizontal',
                            'title' => 'sidebar.categories',
                            'route' => 'backend.categories.index',
                            'active' => ['app/categories'],
                            'permission' => ['view_categories'],
                            'order' => 1,
                            'menu_level' => 2,
                        ],
                        [
                            'menu_type' => 'horizontal',
                            'title' => 'sidebar.sub_categories',
                            'route' => 'backend.categories.index_nested',
                            'active' => ['app/sub-categories'],
                            'permission' => ['view_subcategories'],
                            'order' => 2,
                            'menu_level' => 2,
                        ],
                    ],
                ],
            ],
        ],
        [
            'menu_type' => 'horizontal',
            'title' => 'sidebar.users',
            'menu_item_type' => 'parent',
            'permission' => ['view_customer', 'view_staff', 'view_customer_reviews'],
            'order' => 2,
            'children' => [
                [
                    'menu_type' => 'horizontal',
                    'start_icon' => 'fa-solid fa-address-card',
                    'title' => 'sidebar.staffs',
                    'route' => 'backend.employees.index',
                    'active' => ['app/employees'],
                    'permission' => ['view_staff'],
                    'order' => 0,
                    'menu_level' => 1,
                ],
                [
                    'menu_type' => 'horizontal',
                    'start_icon' => 'fa-solid fa-users',
                    'title' => 'sidebar.customers',
                    'route' => 'backend.customers.index',
                    'active' => ['app/customers'],
                    'permission' => ['view_customer'],
                    'order' => 1,
                    'menu_level' => 1,
                ],
                [
                    'menu_type' => 'horizontal',
                    'start_icon' => 'fa-solid fa-star',
                    'title' => 'sidebar.reviews',
                    'route' => 'backend.employees.review',
                    'active' => ['app/employees-review'],
                    'permission' => ['view_customer_reviews'],
                    'order' => 2,
                    'menu_level' => 1,
                ],
            ],
        ],
        [
            'menu_type' => 'horizontal',
            'title' => 'sidebar.finance',
            'menu_item_type' => 'parent',
            'order' => 3,
            'permission' => ['view_tax', 'view_earning'],
            'children' => [
                [
                    'menu_type' => 'horizontal',
                    'start_icon' => 'fa-solid fa-money-bill-trend-up',
                    'title' => 'sidebar.tax',
                    'route' => 'backend.tax.index',
                    'active' => ['app/tax'],
                    'permission' => ['view_tax'],
                    'order' => 0,
                    'menu_level' => 1,
                ],
                [
                    'menu_type' => 'horizontal',
                    'start_icon' => 'fa-solid fa-money-bill-1-wave',
                    'title' => 'sidebar.staff_earnings',
                    'route' => 'backend.earnings.index',
                    'active' => ['app/earnings'],
                    'order' => 1,
                    'menu_level' => 1,
                ],
                [
                    'start_icon' => 'fa-solid fa-ticket',
                    'title' => 'sidebar.promotion',
                    'route' => 'backend.promotions.index',
                    'active' => ['app/promotions'],
                    'permission' => ['view_role_permissions'],
                    'order' => 2,
                    'menu_level' => 1,
                ],
            ],
        ],
        [
            'menu_type' => 'horizontal',
            'title' => 'sidebar.reports',
            'menu_item_type' => 'parent',
            'order' => 4,
            'permission' => ['daily_booking_report', 'overall_booking_report', 'payout_report', 'employee_report'],
            'children' => [
                [
                    'menu_type' => 'horizontal',
                    'start_icon' => 'fa-solid fa-file-invoice-dollar',
                    'title' => 'sidebar.daily_bookings',
                    'route' => 'backend.reports.daily-booking-report',
                    'active' => ['app/daily-booking-report'],
                    'order' => 0,
                    'permission' => ['daily_booking_report'],
                    'menu_level' => 1,
                ],
                [
                    'menu_type' => 'horizontal',
                    'start_icon' => 'fa-solid fa-chart-line',
                    'title' => 'sidebar.overall_bookings',
                    'route' => 'backend.reports.overall-booking-report',
                    'active' => ['app/overall-booking-report'],
                    'order' => 1,
                    'permission' => ['overall_booking_report'],
                    'menu_level' => 1,
                ],
                [
                    'menu_type' => 'horizontal',
                    'start_icon' => 'fa-solid fa-chart-bar',
                    'title' => 'sidebar.staffs_payouts',
                    'route' => 'backend.reports.payout-report',
                    'active' => ['app/payout-report'],
                    'permission' => ['payout_report'],
                    'order' => 2,
                    'menu_level' => 1,
                ],
                [
                    'menu_type' => 'horizontal',
                    'start_icon' => 'fa-solid fa-clipboard-user',
                    'title' => 'sidebar.staffs_services',
                    'route' => 'backend.reports.staff-report',
                    'active' => ['app/staff-report'],
                    'permission' => ['employee_report'],
                    'order' => 3,
                    'menu_level' => 1,
                ],
            ],
        ],
        [
            'menu_type' => 'horizontal',
            'title' => 'sidebar.system',
            'menu_item_type' => 'parent',
            'order' => 5,
            'permission' => ['system_settings', 'view_page', 'view_app_banner', 'view_role_permissions'],
            'children' => [
                [
                    'menu_type' => 'horizontal',
                    'start_icon' => 'fa-solid fa-gear',
                    'title' => 'sidebar.settings',
                    'route' => 'backend.settings',
                    'active' => 'app/settings',
                    'permission' => ['system_settings'],
                    'order' => 0,
                    'menu_level' => 1,
                ],
                [
                    'menu_type' => 'horizontal',
                    'start_icon' => 'fa-solid fa-file',
                    'title' => 'sidebar.pages',
                    'route' => 'backend.pages.index',
                    'active' => ['app/pages'],
                    'permission' => ['view_page'],
                    'order' => 1,
                    'menu_level' => 1,
                ],
                [
                    'menu_type' => 'horizontal',
                    'start_icon' => 'fa-solid fa-bell',
                    'title' => 'sidebar.notifications',
                    'nickname' => 'notifications',
                    'order' => 2,
                    'menu_level' => 1,
                    'menu_item_type' => 'parent',
                    'permission' => ['view_notification_list', 'view_notification_template'],
                    'children' => [
                        [
                            'menu_type' => 'horizontal',
                            'title' => 'sidebar.list',
                            'route' => 'backend.notifications.index',
                            'active' => 'app/notifications',
                            'permission' => ['view_notification_list'],
                            'order' => 0,
                            'menu_level' => 2,
                        ],
                        [
                            'menu_type' => 'horizontal',
                            'title' => 'sidebar.templates',
                            'route' => 'backend.notification-templates.index',
                            'active' => 'app/notification-templates*',
                            'permission' => ['view_notification_template'],
                            'order' => 1,
                            'menu_level' => 2,
                        ],
                    ],
                ],
                [
                    'menu_type' => 'horizontal',
                    'start_icon' => 'fa fa-sliders',
                    'title' => 'sidebar.app_banner',
                    'route' => 'backend.app-banners.index',
                    'active' => 'app/app-banners',
                    'permission' => ['view_app_banner'],
                    'order' => 3,
                    'menu_level' => 1,
                ],
                [
                    'menu_type' => 'horizontal',
                    'start_icon' => 'fa-solid fa-user-shield',
                    'title' => 'sidebar.access_control',
                    'route' => 'backend.permission-role.list',
                    'active' => ['app/permission-role'],
                    'permission' => ['view_role_permissions'],
                    'order' => 4,
                    'menu_level' => 1,
                ],
            ],
        ],
    ],
    'menu_routes' => [
        [
            'route' => 'backend.home',
            'title' => 'Dashboard',
        ],
        [
            'route' => 'backend.bookings.index',
            'title' => 'Calendar Bookings',
        ],
        [
            'route' => 'backend.branch.index',
            'title' => 'Branches',
        ],
        [
            'route' => 'backend.bookings.datatable_view',
            'title' => 'Bookings',
        ],
        [
            'route' => 'backend.services.index',
            'title' => 'Services List',
        ],
        [
            'route' => 'backend.categories.index',
            'title' => 'Categories',
        ],
        [
            'route' => 'backend.categories.index_nested',
            'title' => 'Sub Categories',
        ],
        [
            'route' => 'backend.employees.index',
            'title' => 'Staffs',
        ],
        [
            'route' => 'backend.customers.index',
            'title' => 'Customers',
        ],
        [
            'route' => 'backend.employees.review',
            'title' => 'Reviews',
        ],
        [
            'route' => 'backend.tax.index',
            'title' => 'Tax',
        ],
        [
            'route' => 'backend.earnings.index',
            'title' => 'Staff Earnings',
        ],
        [
            'route' => 'backend.reports.daily-booking-report',
            'title' => 'Daily Bookings',
        ],
        [
            'route' => 'backend.reports.overall-booking-report',
            'title' => 'Overall Bookings',
        ],
        [
            'route' => 'backend.reports.payout-report',
            'title' => 'Staffs Payouts',
        ],
        [
            'route' => 'backend.reports.staff-report',
            'title' => 'Staffs Services',
        ],
        [
            'route' => 'backend.settings',
            'title' => 'Settings',
        ],
        [
            'route' => 'backend.pages.index',
            'title' => 'Pages',
        ],
        [
            'route' => 'backend.notifications.index',
            'title' => 'List',
        ],
        [
            'route' => 'backend.notification-templates.index',
            'title' => 'Templates',
        ],
        [
            'route' => 'backend.app-banners.index',
            'title' => 'App Banner',
        ],
        [
            'route' => 'backend.permission-role.list',
            'title' => 'Access Control',
        ],
    ],
];
