import 'package:flutter/material.dart';
import 'package:flutter_mobx/flutter_mobx.dart';
import 'package:frezka/screens/auth/view/sign_in_screen.dart';
import 'package:frezka/utils/colors.dart';
import 'package:frezka/utils/extensions/string_extensions.dart';
import 'package:frezka/utils/images.dart';
import 'package:nb_utils/nb_utils.dart';

import '../../../components/voice_search_component.dart';
import '../../../main.dart';
import '../../../utils/common_base.dart';
import '../../../utils/constants.dart';
import '../../branch/view/select_branch_screen.dart';
import '../../product/view/product_dashboard_screen.dart';
import '../fragment/booking_fragment.dart';
import '../fragment/home_fragment.dart';
import '../fragment/profile_fragment.dart';

class DashboardScreen extends StatefulWidget {
  final int pageIndex;

  const DashboardScreen({super.key, this.pageIndex = 0});

  @override
  _DashboardScreenState createState() => _DashboardScreenState();
}

class _DashboardScreenState extends State<DashboardScreen> with WidgetsBindingObserver {
  int currentPosition = 0;

  List<Widget> fragmentList = [
    HomeFragment(),
    Observer(builder: (context) => appStore.isLoggedIn ? BookingFragment() : SignInScreen(isFromDashboard: true)),
    ProductScreen(),
    ProfileFragment(),
  ];

  @override
  void initState() {
    currentPosition = widget.pageIndex;
    if (getIntAsync(THEME_MODE_INDEX) == ThemeConst.THEME_MODE_SYSTEM) {
      WidgetsBinding.instance.addObserver(this);
    }
    super.initState();
    init();
  }

  void init() async {
    afterBuildCreated(() async {
      /// Changes System theme when changed
      if (getIntAsync(THEME_MODE_INDEX) == ThemeConst.THEME_MODE_SYSTEM) {
        appStore.setDarkMode(context.platformBrightness() == Brightness.dark);
      }

      /*View.of(context).platformDispatcher.onPlatformBrightnessChanged = () async {
        if (getIntAsync(THEME_MODE_INDEX) == ThemeConst.THEME_MODE_SYSTEM) {
          appStore.setDarkMode(MediaQuery.of(context).platformBrightness == Brightness.light);
        }
      };*/

      //WidgetsBinding.instance.handlePlatformBrightnessChanged();
    });

    if (isMobile) {
      /// Handle Notification click and redirect to that Service & BookDetail screen

      //TODO: check redirect
      /*OneSignal.Notifications.addClickListener((event) {
        toast("Notification Coming===================");
        if (event.notification.additionalData != null) {
          if (event.notification.additionalData != null) {
            final additionalData = event.notification.additionalData!['additional_data'];
            NotificationDetail nData = NotificationDetail.fromJson(additionalData);
            if (nData.id.validate() > 0) {
              if (nData.notificationGroup == "shop") {
                OrderDetailScreen(orderId: nData.id.validate(), orderCode: nData.orderCode.validate()).launch(context, pageRouteAnimation: PageRouteAnimation.Fade);
              } else {
                BookingDetailScreen(bookingId: nData.id.validate().toInt()).launch(context);
              }
            }
          }
        }
      });*/
    }

    /// ForceUpdate Dialog
    await 3.seconds.delay;
    showForceUpdateDialog(context);

    if (!appStore.isBranchSelected) {
      SelectBranchScreen().launch(context, isNewTask: true);
    }
  }

  @override
  void setState(fn) {
    if (mounted) super.setState(fn);
  }

  @override
  void didChangePlatformBrightness() {
    if (getIntAsync(THEME_MODE_INDEX) == ThemeConst.THEME_MODE_SYSTEM) {
      appStore.setDarkMode(MediaQuery.of(context).platformBrightness == Brightness.light);
    }
    super.didChangePlatformBrightness();
  }

  @override
  void dispose() {
    WidgetsBinding.instance.removeObserver(this);
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    return DoublePressBackWidget(
      message: locale.pressBackAgainToExitApp,
      child: Scaffold(
        body: fragmentList[currentPosition],
        bottomNavigationBar: Blur(
          blur: 30,
          borderRadius: radius(0),
          child: NavigationBarTheme(
            data: NavigationBarThemeData(
              backgroundColor: context.primaryColor.withOpacity(0.02),
              indicatorColor: context.primaryColor.withOpacity(0.1),
              labelTextStyle: MaterialStateProperty.all(primaryTextStyle(size: 12)),
              surfaceTintColor: Colors.transparent,
              shadowColor: Colors.transparent,
            ),
            child: NavigationBar(
              selectedIndex: currentPosition,
              onDestinationSelected: (index) {
                currentPosition = index;
                setState(() {});
              },
              destinations: [
                bottomTab(
                  iconData: ic_unselected_home.iconImage(color: appTextSecondaryColor, size: 18),
                  activeIconData: ic_selected_home.iconImage(color: context.primaryColor, size: 18),
                  tabName: locale.home,
                ),
                bottomTab(
                  iconData: ic_unselected_booking.iconImage(color: appTextSecondaryColor, size: 18),
                  activeIconData: ic_selected_booking.iconImage(color: context.primaryColor, size: 18),
                  tabName: locale.booking,
                ),
                bottomTab(
                  iconData: ic_unselected_shop.iconImage(color: appTextSecondaryColor, size: 20),
                  activeIconData: ic_selected_shop.iconImage(color: context.primaryColor, size: 20),
                  tabName: locale.shop, //TODO: string
                ),
                bottomTab(
                  iconData: ic_unselected_profile.iconImage(color: appTextSecondaryColor, size: 18),
                  activeIconData: ic_selected_profile.iconImage(color: context.primaryColor, size: 18),
                  tabName: locale.user,
                ),
              ],
            ),
          ),
        ),
        bottomSheet: Observer(builder: (context) {
          return VoiceSearchComponent().visible(appStore.isSpeechActivated);
        }),
      ),
    );
  }
}
